#include <iostream>
#include <set>
#include "Structures.h"
#include "AneuMeshLoader.h"
#include <memory>

int main() 
{
    // НЕ НАДО ИСПОЛЬЗОВАТЬ ОПЕРАТОР new, ИСПОЛЬЗУЙ  make ФУНКЦИЮ
    // И УКАЗАТЕЛЬ НУЖЕН unique_ptr, ЗДЕСЬ ЖЕ НЕ ПЛАНИРУЕТСЯ
    // МНОЖЕСТВЕННОЕ ВЛАДЕНИЕ
    MeshLoader* loader = new AneuMeshLoader;
    std::shared_ptr<MeshLoader> smart_loader(loader);
    smart_loader->loadMesh("cube.aneu");
    const auto& nodeSTL = smart_loader->getVectorOfNodes();
    const auto& finiteSTL = smart_loader->getVectorOfFE();
    const auto& boundarySTL = smart_loader->getVectorOfBFE();

    auto FEById = smart_loader->getFiniteElementsById(2, 4, 8);
    auto FEByEdge = smart_loader->getFiniteElementsByEdge(2, 8);
    auto FEByType = smart_loader->getFiniteElementsByMaterial(0);
    auto nodesByBoundary = smart_loader->getNodeSTLByBoundaryId(1);
    auto BFEByBoundary = smart_loader->getBoundaryFiniteElementsSTLByBoundaryId(1);
    auto neighbours = smart_loader->getNeighbourSTL();

    smart_loader->PrintData();
    smart_loader->insertNodesInCenter();
    smart_loader->PrintData();

    return 0;
}
